/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.gui.components;

import com.github.charlyb01.music_control.categories.Music;
import com.github.charlyb01.music_control.config.ModConfig;
import com.github.charlyb01.music_control.gui.components.Button;
import com.github.charlyb01.music_control.gui.components.ButtonListPanel;
import io.github.cottonmc.cotton.gui.widget.WBox;
import io.github.cottonmc.cotton.gui.widget.WCardPanel;
import io.github.cottonmc.cotton.gui.widget.WToggleButton;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class SoundListPanel
extends WBox {
    public SoundListPanel(BiConsumer<class_2960, Button> onMusicClicked, BiConsumer<class_2960, Button> onEventClicked, Consumer<Boolean> onToggle, int width, boolean isEventList) {
        super(Axis.VERTICAL);
        ArrayList<class_2960> events = new ArrayList<class_2960>(Music.EVENTS);
        ArrayList<class_2960> musics = new ArrayList<class_2960>(Music.MUSIC_BY_NAMESPACE.get("all").size());
        for (Music music : Music.MUSIC_BY_NAMESPACE.get("all")) {
            musics.add(music.getIdentifier());
        }
        ButtonListPanel musicListPanel = new ButtonListPanel(musics, onMusicClicked, width, ModConfig.get().cosmetics.gui.height - 20);
        ButtonListPanel eventListPanel = new ButtonListPanel(events, onEventClicked, width, ModConfig.get().cosmetics.gui.height - 20);
        WCardPanel listPanel = new WCardPanel();
        listPanel.add((WWidget)musicListPanel);
        listPanel.add((WWidget)eventListPanel);
        if (isEventList) {
            listPanel.setSelectedCard((WWidget)eventListPanel);
        }
        WToggleButton toggleButton = new WToggleButton((class_2561)class_2561.method_43471((String)"gui.music_control.toggle.musicEvent"));
        toggleButton.setToggle(isEventList);
        toggleButton.setOnToggle(isEvent -> {
            onToggle.accept((Boolean)isEvent);
            if (isEvent.booleanValue()) {
                listPanel.setSelectedCard((WWidget)eventListPanel);
            } else {
                listPanel.setSelectedCard((WWidget)musicListPanel);
            }
        });
        this.add((WWidget)toggleButton);
        this.add((WWidget)listPanel);
    }
}

